/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : perfdefs.h
************************************************************************
* Written by    : Stefan Friebe, BID R&D, 24.2.98
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, 
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef PERFDEFS_H_INCLUDED                               
#define PERFDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif


/* ---------------------------------------------------------------
 * Type Definitions for Performance Functions
 * --------------------------------------------------------------- */

/* transient properties of a performance sequencer */

/* do NOT (NEVER EVER) touch these offset values... */
#define B_PERFSEQ_PROP_OFFSET   11

CLI typedef enum {
    B_PERFSEQ_STATE,          /* @state     */
    B_PERFSEQ_NEXTSTATE       /* @nextstate */
} b_perfseqtranproptype;

#define B_PERFSEQ_CONDITION_OFFSET   14

CLI typedef enum {
    B_PERFSEQ_XCOND,          /* @x         */
    B_PERFSEQ_CA_EN,          /* @caen      */
    B_PERFSEQ_CB_EN,          /* @cben      */
    B_PERFSEQ_CC_EN,          /* @ccen      */
    B_PERFSEQ_CC_LOAD         /* @ccload    */
} b_perfseqtrancondproptype;


/* these are the performance measure generic properties */

/* whatever Robert wanted to do with it, we are compatible ... */
#define B_PERFSEQ_GEN_PREL_OFFSET   10
#define B_PERFSEQ_GEN_CAMODE_OFFSET 126

CLI typedef enum {
    B_PERFGEN_CTRC_PREL, /* @cprel     */
    B_PERFGEN_CAMODE    /* @mode      */
} b_perfgenproptype;


/* these are the counter identifiers of a performance measure */

CLI /* DEF_START ~G_PerfCntIdent */

#define    B_PERFCTR_A    0          /* @ctra      */
#define    B_PERFCTR_B    1          /* @ctrb      */
#define    B_PERFCTR_C    2          /* @ctrc      */
#define    B_REFCTR       3          /* @refc      */
#define    B_PERFCTR_A_HI 4          /* @ctrahi      */
#define    B_PERFCTR_B_HI 5          /* @ctrbhi      */
#define    B_PERFCTR_C_HI 6          /* @ctrchi      */
#define    B_REFCTR_HI    7          /* @refchi      */

CLI /* DEF_END */


CLI /* DEF_START ~G_PerfSeq */

#define	   B_CAMODE_INCR1       0    /* @incr1      */
#define    B_CAMODE_INCRBYTEN   1    /* @incrbyten  */
#define    B_PERFMEAS_0         0    /* @meas0      */
#define    B_PERFMEAS_1         1    /* @meas1      */
#define    B_PERFMEAS_2         2    /* @meas2      */
#define    B_PERFMEAS_3         3    /* @meas3      */
#define    B_PERFMEAS_4         4    /* @meas4      */
#define    B_PERFMEAS_5         5    /* @meas5      */
#define    B_PERFMEAS_6         6    /* @meas6      */
#define    B_PERFMEAS_7         7    /* @meas7      */

CLI /* DEF_END */



#endif


